package cn.com.duiba.cloud.duiba.http.client.handler.analysis.method.impl.body;

import cn.com.duiba.cloud.duiba.http.client.annotation.HttpFile;
import cn.com.duiba.cloud.duiba.http.client.bo.FileParam;
import cn.com.duiba.cloud.duiba.http.client.context.body.FileBody;
import cn.com.duiba.cloud.duiba.http.client.context.body.UploadFile;
import cn.com.duiba.cloud.duiba.http.client.context.body.UploadMultipartFile;
import cn.com.duiba.cloud.duiba.http.client.exception.ParamException;
import cn.com.duiba.cloud.duiba.http.client.handler.analysis.method.AnalysisMethodParamHandler;
import cn.com.duiba.cloud.duiba.http.client.utils.AnnotationUtil;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Objects;

/**
 *
 * @date : 2021/12/12 15:28
 * @author: linzhou
 * @description : 文件参数处理器
 */
@Component
public class HttpFileHandler implements AnalysisMethodParamHandler {
    @Override
    public Object analysisMethodParam(Object param, Annotation[] annotations) throws IOException {
        HttpFile httpFile = AnnotationUtil.findHttpAnnotation(annotations, HttpFile.class);
        if (Objects.nonNull(httpFile)){
            return getUploadFile(param,httpFile);
        }
        return null;
    }
    /**
     * 处理文件上传
     *
     * @param arg
     * @param httpFile
     * @return
     */
    private FileBody getUploadFile(Object arg, HttpFile httpFile) throws IOException {
        FileBody uploadFile;
        //保存需要上传的文件信息
        if (arg instanceof MultipartFile) {
            uploadFile = new UploadMultipartFile(httpFile, (MultipartFile) arg);
        } else if (arg instanceof FileParam) {
            FileParam fileParam = (FileParam) arg;
            uploadFile = new UploadMultipartFile(httpFile, fileParam.getFile(), fileParam.getParam());
        } else if (arg instanceof File) {
            uploadFile = new UploadFile(httpFile, (File) arg);
        } else {
            throw new ParamException("参数格式错误,上传文件应为MultipartFile或者file类型,当前类型:" + arg.getClass().getName());
        }
        return uploadFile;
    }
}
