package cn.com.duiba.cloud.duiba.http.client.handler.analysis.method.impl.form;

import cn.com.duiba.cloud.duiba.http.client.annotation.HttpParam;
import cn.com.duiba.cloud.duiba.http.client.context.form.NameValueParam;
import cn.com.duiba.cloud.duiba.http.client.exception.ParamException;
import cn.com.duiba.cloud.duiba.http.client.handler.analysis.method.AnalysisMethodParamHandler;
import cn.com.duiba.cloud.duiba.http.client.utils.AnnotationUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @date : 2021/12/12 15:24
 * @author: linzhou
 * @description : 非基础类型表单参数处理器
 */
@Component
public class HttpParamNotBasicClassHandler implements AnalysisMethodParamHandler {
    @Override
    public Object analysisMethodParam(Object param, Annotation[] annotations) {
        HttpParam httpParam = AnnotationUtil.findHttpAnnotation(annotations, HttpParam.class);
        if (Objects.nonNull(httpParam) && !isBasicClass(param) && !(param instanceof Collection)) {
            //处理表单参数
            return getNameValueParam(param, httpParam);
        }
        return null;
    }

    /**
     * 处理表单
     */
    private List<NameValueParam> getNameValueParam(Object arg, HttpParam httpParam) {

        if (arg == null) {
            return Collections.emptyList();
        }

        Object o = JSONObject.toJSON(arg);

        if (!(o instanceof JSONObject)) {
            throw new ParamException("类型错误,error class:" + arg.getClass().getName());
        }
        List<NameValueParam> nameValueParams = new ArrayList<>();

        JSONObject jsonObject = (JSONObject) o;
        for (Map.Entry<String, Object> entry : jsonObject.entrySet()) {
            String value = objectToString(entry.getValue());
            if (StringUtils.isBlank(value)){
                continue;
            }
            NameValueParam nameValueParam = new NameValueParam(entry.getKey(), value);
            nameValueParams.add(nameValueParam);
        }
        return nameValueParams;
    }

    private String objectToString(Object o) {
        if (Objects.isNull(o)) {
            return null;
        }
        if (o instanceof String) {
            return (String) o;
        }
        return JSON.toJSONString(o);
    }

    /**
     * 是否是基础类型
     *
     * @param o
     * @return
     */
    protected boolean isBasicClass(Object o) {
        if (o instanceof Integer
                || o instanceof String
                || o instanceof Double
                || o instanceof Float
                || o instanceof Long
                || o instanceof BigDecimal) {
            return true;
        }
        return false;
    }
}
