package cn.com.duiba.cloud.duiba.http.client.handler.http.result;


import cn.com.duiba.cloud.duiba.http.client.response.HttpClientResponse;
import cn.com.duiba.cloud.duiba.http.client.utils.SpringUtil;
import org.apache.commons.collections4.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 *
 * @date : 2021/12/12 15:49
 * @author: linzhou
 * @description : HttpClientResultHandlerManager
 */
public class HttpClientResultHandlerManager {

    private static List<HttpClientResultHandler> httpClientResultHandlers;

    public static Object getReturnObject(HttpClientResponse response) throws Exception {

        List<HttpClientResultHandler> httpClientResultHandlers = getAnalysisMethodParamHandlers();
        Class<?> returnType = response.getContext().getMethod().getReturnType();
        for (HttpClientResultHandler httpClientResultHandler : httpClientResultHandlers) {
            Object rlt = httpClientResultHandler.getReturnObject(response,returnType);
            if (Objects.nonNull(rlt)){
                return rlt;
            }
        }
        return null;
    }

    private static List<HttpClientResultHandler> getAnalysisMethodParamHandlers(){
        if (CollectionUtils.isEmpty(httpClientResultHandlers)){
            httpClientResultHandlers = SpringUtil.getBeanList(HttpClientResultHandler.class);
        }
        return httpClientResultHandlers;
    }
}
