package cn.com.duiba.cloud.duiba.http.client.handler.http.result.impl;

import cn.com.duiba.cloud.duiba.http.client.handler.http.result.HttpClientResultHandler;
import cn.com.duiba.cloud.duiba.http.client.response.HttpClientResponse;
import cn.com.duiba.cloud.duiba.http.client.utils.HttpClientFileUtil;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

/**
 *
 * @date : 2021/12/12 15:53
 * @author: linzhou
 * @description : MultipartFile返回处理
 */
@Component
@Order(-1)
public class MultipartFileHttpClientResultHandler implements HttpClientResultHandler {
    @Override
    public Object getReturnObject(HttpClientResponse response, Class<?> returnType) throws Exception {
        if (returnType == MultipartFile.class) {
            return HttpClientFileUtil.getMockMultipartFile(response);
        }
        return null;
    }
}
