package cn.com.duiba.cloud.duiba.http.client.handler.http.result.impl;

import cn.com.duiba.cloud.duiba.http.client.exception.HttpErrorException;
import cn.com.duiba.cloud.duiba.http.client.handler.http.result.HttpClientResultHandler;
import cn.com.duiba.cloud.duiba.http.client.response.HttpClientResponse;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

/**
 *
 * @date : 2021/12/12 15:52
 * @author: linzhou
 * @description : 判断本次请求状态是否是200
 */
@Component
@Order(-10)
public class SuccessfulHttpClientResultHandler implements HttpClientResultHandler {
    @Override
    public Object getReturnObject(HttpClientResponse response, Class<?> returnType) throws Exception {
        if (!response.isSuccessful()) {
            throw new HttpErrorException(response.string());
        }
        return null;
    }
}
