package cn.com.duiba.cloud.duiba.http.client.utils;

import org.apache.commons.collections4.CollectionUtils;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 *
 * @date : 2021/12/26 18:30
 * @author: linzhou
 * @description : AutoCloseUtil
 */
public class AutoCloseUtil {

    private static final ThreadLocal<List<Closeable>> THREAD_LOCAL = new ThreadLocal<List<Closeable>>(){
        @Override
        protected List<Closeable> initialValue() {
            return new ArrayList<>();
        }
    };

    public static void addCloseable(Closeable closeable){
        THREAD_LOCAL.get().add(closeable);
    }

    public static void closeAll(){
        List<Closeable> closeables = THREAD_LOCAL.get();
        if (CollectionUtils.isNotEmpty(closeables)) {
            for (Closeable closeable : closeables) {
                try {
                    if (Objects.nonNull(closeable)) {
                        closeable.close();
                    }
                } catch (IOException e) {
                }
            }
        }
        clear();
    }

    public static void clear(){
        THREAD_LOCAL.get().clear();
    }
}
