package cn.com.duiba.cloud.duiba.http.client.utils;


import cn.com.duiba.cloud.duiba.http.client.response.HttpClientResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.mock.web.MockMultipartFile;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;

/**
 * @author linzhou
 * @ClassName FileUtil.java
 * @createTime 2021年12月08日 15:55:00
 * @Description
 */
public class HttpClientFileUtil {
    private static final String DEFAULT_PATH = "src/main/resources/httpClient";

    public static File downFile(HttpClientResponse response) {
        return downFile(response, DEFAULT_PATH);
    }

    public static File downFile(HttpClientResponse response, String downPath) {
        String fileName = getFileName(response);
       return FileUtil.downFile(response.getInputStream(),downPath,fileName);
    }



    /**
     * 获取文件
     *
     * @param response
     * @return
     * @throws IOException
     */
    public static MockMultipartFile getMockMultipartFile(HttpClientResponse response) throws IOException {
        //创建文件
        return new MockMultipartFile(getFileName(response), response.getInputStream());
    }

    /**
     * 获取文件名称
     */
    private static String getFileName(HttpClientResponse response) {
        //从header中获取文件名称
        return Optional.ofNullable(getHeaderFileName(response))
                //如果header中没有文件名称,则从url上获取
                .orElse(getUrlFileName(response));
    }

    private static String getFilePath( String path,String fileName) {
        if (StringUtils.isBlank(path)) {
            return fileName;
        }
        StringBuilder stringBuilder = new StringBuilder(path);
        if (path.lastIndexOf("/") != path.length()) {
            stringBuilder.append("/");
        }
        return stringBuilder.append(fileName).toString();
    }

    /**
     * 解析文件头
     * Content-Disposition:attachment;filename=FileName.txt
     * Content-Disposition: attachment; filename*="UTF-8''%E6%9B%BF%E6%8D%A2%E5%AE%9E%E9%AA%8C%E6%8A%A5%E5%91%8A.pdf"
     */
    private static String getHeaderFileName(HttpClientResponse response) {
        String dispositionHeader = response.getHeader("Content-Disposition");
        if (StringUtils.isNotBlank(dispositionHeader)) {
            String[] strings = dispositionHeader.split(";");
            if (strings.length > 1) {
                dispositionHeader = strings[1].replace("filename=", "");
                dispositionHeader = dispositionHeader.replace("fileName=", "");
                dispositionHeader = dispositionHeader.replace("\"", "");
                return dispositionHeader;
            }
        }
        return null;
    }

    /**
     * 通过url获取文件名称
     *
     * @param response
     * @return
     */
    public static String getUrlFileName(HttpClientResponse response) {
        return Optional.ofNullable(response)
                .map(HttpClientResponse::getHttpUrl)
                .map(o -> o.substring(o.lastIndexOf("/") + 1))
                .orElse("HttpClientDownFile");

    }
}
