package cn.com.duiba.cloud.duiba.http.client.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

/**
 * @author linzhou
 * @ClassName IoStreamUtils.java
 * @createTime 2022年01月21日 15:17:00
 * @Description
 */
public class IoStreamUtils {

    public static byte[] getByte(InputStream inputStream) throws IOException {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = inputStream.read(buffer))) {
                output.write(buffer, 0, n);
            }
            return output.toByteArray();
        }finally {
            if (Objects.nonNull(inputStream)){
                inputStream.close();
            }
        }
    }

    public static InputStream getInputStream(byte[] bytes){
        return new ByteArrayInputStream(bytes);
    }

    public static InputStream copyInputStream(InputStream inputStream) throws IOException {
        return getInputStream(getByte(inputStream));
    }
}
