package cn.com.duiba.cloud.log.client;

import cn.com.duiba.cloud.log.client.service.BusinessLoggerService;
import cn.com.duiba.cloud.log.client.service.BusinessLoggerStackContext;
import com.alibaba.fastjson.JSONObject;

import java.util.Objects;

/**
 * 业务日志
 * @author liuyao
 */
public class BusinessLogger {

    private static volatile BusinessLoggerService businessLoggerService;

    /**
     * 通过json渲染日志
     */
    public static BusinessLoggerStackContext addLogParams(JSONObject json) {
        Objects.requireNonNull(json);
        BusinessLoggerStackContext context = businessLoggerService.getBusinessLoggerStackContext();
        context.addLogParam(json);
        return context;
    }

    public static BusinessLoggerStackContext addLogParams(String key,Object value){
        BusinessLoggerStackContext context = businessLoggerService.getBusinessLoggerStackContext();
        context.addLogParam(key,value);
        return context;
    }

    public static void setBusinessLoggerService(BusinessLoggerService businessLoggerService) {
        BusinessLogger.businessLoggerService = businessLoggerService;
    }
}