package cn.com.duiba.cloud.log.client;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @description 日志注解
 * @author dangcang
 * @date 2021/11/3 10:59 上午
 **/
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface BusinessLoggerMethod {

    /**
     * 日志模板
     */
    String template() default "";

    /**
     * 日志编组
     */
    String group() default "默认";

    /**
     * 记录 request 变量
     */
    boolean request() default false;

    /**
     * 记录返回结果
     */
    boolean response() default false;
}