package cn.com.duiba.cloud.log.client.configuration;

import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

import java.util.Map;
import java.util.Objects;

/**
 * @author liuyao
 */
public class BusinessLogAppenderCondition implements Condition {

    @Override
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Map<String, Object> attributes = metadata.getAnnotationAttributes(ConditionalOnBusinessLogAppender.class.getName());
        BusinessLoggerAppenderType type = (BusinessLoggerAppenderType) Objects.requireNonNull(attributes).get("value");
        BindResult<BusinessLoggerAppenderType> bindResult = Binder.get(context.getEnvironment()).bind("duiba.cloud.business.log.logger-appender-type",BusinessLoggerAppenderType.class);
        if(!bindResult.isBound()){
            return Objects.equals(type,BusinessLoggerAppenderType.RPC);
        }else{
            return Objects.equals(type,bindResult.get());
        }
    }
}
