package cn.com.duiba.cloud.log.client.configuration;

import cn.com.duiba.cloud.log.client.integration.appender.rest.RpcBusinessLoggerConfiguration;
import cn.com.duiba.cloud.log.client.integration.appender.rocketmq.RocketMqBusinessLoggerConfiguration;
import cn.com.duiba.cloud.log.client.integration.interceptor.RequestBusinessLoggerConfiguration;
import cn.com.duiba.cloud.log.client.integration.interceptor.SleuthBusinessLoggerConfiguration;
import cn.com.duiba.cloud.log.client.service.BusinessLoggerProxy;
import cn.com.duiba.cloud.log.client.service.BusinessLoggerService;
import cn.com.duiba.wolf.concurrent.AbortPolicyWithReport;
import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author liuyao
 */
@EnableAspectJAutoProxy
@Configuration
@Import({
        SleuthBusinessLoggerConfiguration.class,
        RequestBusinessLoggerConfiguration.class,
        RpcBusinessLoggerConfiguration.class,
        RocketMqBusinessLoggerConfiguration.class
})
@EnableConfigurationProperties({BusinessLogProperties.class})
public class BusinessLogAutoConfiguration {

    /**
     * 日志异步线程池
     */
    @Bean(destroyMethod = "shutdown")
    public ExecutorService logExecutorService(BusinessLogProperties businessLogProperties) {
        BlockingQueue<Runnable> queue = new ArrayBlockingQueue<>(500);
        return new ThreadPoolExecutor(businessLogProperties.getSendThreads(), businessLogProperties.getSendThreads() * 2,
                60L, TimeUnit.SECONDS,
                queue,
                new NamedThreadFactory("business-log"),
                new AbortPolicyWithReport());
    }

    @Bean
    public BusinessLoggerProxy businessLoggerProxy() {
        return new BusinessLoggerProxy();
    }

    @Bean
    public BusinessLoggerService businessLoggerService() {
        return new BusinessLoggerService();
    }


}
