package cn.com.duiba.cloud.log.client.domain;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 日志请求
 *
 * @author liuyao
 */
@Data
public class BusinessLog implements Serializable {

    private static final long serialVersionUID = 1078185031940410254L;

    private String uuid;

    /**
     * 提交日志的ip
     */
    private String ip;

    /**
     * 当前环境
     */
    private String environment;

    /**
     * 提交日志的链路id
     */
    private String traceId;

    /**
     * spanId
     */
    private String spanId;

    /**
     * 操作人名字
     */
    private String operator;

    /**
     * 系统名称
     */
    private String appName;

    /**
     * 系统级别租户纬度字段
     */
    private String appInfoId;

    /**
     * 模块名称
     */
    private String group;

    /**
     * 日志参数
     */
    private String paramsJson;

    /**
     * 渲染后的日志正文
     */
    private String logContent;

    /**
     * 日志发生时间
     */
    private Date actionTime;

    /**
     * 是否异常日志
     */
    private boolean errorLog = false;

    /**
     * 自定义搜索字段
     */
    private List<String> searchList;
}