package cn.com.duiba.cloud.log.client.domain;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * @author xiaotian
 * @date 2021/11/12
 * 日志分页查询
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class BusinessLogPageParams extends PageRequest {
    private static final long serialVersionUID = -8927347282529818036L;
    /**
     * 系统名称
     */
    private String appName;
    /**
     * 开始时间
     */
    @NotNull
    private Date startTime;
    /**
     * 结束时间
     */
    @NotNull
    private Date endTime;
    /**
     * 日志编组
     */
    private String group;
    /**
     * 日志详情关键字
     */
    private String key;
    /**
     * 操作人
     */
    private String operator;
    /**
     * 系统级别租户纬度字段
     */
    private String appInfoId;
    /**
     * 是否包含异常日志
     */
    private boolean containError = false;

    /**
     * 自定义搜索字段
     */
    private List<String> searchList;
}
