package cn.com.duiba.cloud.log.client.integration.appender.rest;

import cn.com.duiba.cloud.log.client.domain.BusinessLog;
import cn.com.duiba.cloud.log.client.integration.BusinessLoggerAppender;
import cn.com.duiba.cloud.log.client.remoteservice.RemoteBusinessLoggerService;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

/**
 * 通过远程接口直接上传
 * @author liuyao
 */
@Slf4j
public class RpcBusinessLoggerAppender implements BusinessLoggerAppender {

    @Resource
    private RemoteBusinessLoggerService remoteBusinessLoggerService;

    @Override
    public void acceptLog(BusinessLog param) {
        try {
            remoteBusinessLoggerService.log(param);
        }catch (Exception e){
            log.error("上传操作日志失败",e);
        }

    }

}
