package cn.com.duiba.cloud.log.client.integration.appender.rest;

import cn.com.duiba.cloud.log.client.configuration.BusinessLoggerAppenderType;
import cn.com.duiba.cloud.log.client.configuration.ConditionalOnBusinessLogAppender;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 通过远程接口上传
 * @author liuyao
 */
@Slf4j
@Configuration
@ConditionalOnBusinessLogAppender(BusinessLoggerAppenderType.RPC)
public class RpcBusinessLoggerConfiguration {

    @Bean
    public RpcBusinessLoggerAppender rpcBusinessLoggerAppender(){
        log.info("使用RPC方式提交业务日志");
        return new RpcBusinessLoggerAppender();
    }

}
