package cn.com.duiba.cloud.log.client.integration.appender.rocketmq;

import cn.com.duiba.cloud.log.client.domain.BusinessLog;
import cn.com.duiba.cloud.log.client.integration.BusinessLoggerAppender;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.spring.core.RocketMQTemplate;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @author liuyao
 */
@Slf4j
public class RocketMqBusinessLoggerAppender implements BusinessLoggerAppender {

    @Resource
    private RocketMQTemplate rocketMqTemplate;
    @Resource
    private RocketMqProperties rocketMqProperties;

    @Override
    public void acceptLog(BusinessLog param) {
        try {
            SendResult result = rocketMqTemplate.syncSend(rocketMqProperties.getTopic(),param,rocketMqProperties.getSendMsgTimeoutMillis());
            if (Objects.isNull(result) || !SendStatus.SEND_OK.equals(result.getSendStatus())) {
                log.error("send mq error, send={}, body={}", JSON.toJSONString(result), param);
            }
        } catch (Exception e) {
            log.error("发送消息失败：", e);
        }

    }
}
