package cn.com.duiba.cloud.log.client.integration.appender.rocketmq;

import cn.com.duiba.cloud.log.client.configuration.BusinessLoggerAppenderType;
import cn.com.duiba.cloud.log.client.configuration.ConditionalOnBusinessLogAppender;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author liuyao
 */
@Slf4j
@Configuration
@ConditionalOnClass(RocketMQTemplate.class)
@EnableConfigurationProperties(RocketMqProperties.class)
@ConditionalOnBusinessLogAppender(BusinessLoggerAppenderType.ROCKET_MQ)
public class RocketMqBusinessLoggerConfiguration {

    @Bean
    public RocketMqBusinessLoggerAppender rocketMqBusinessLoggerAppender(){
        log.info("使用rocketmq方式提交业务日志");
        return new RocketMqBusinessLoggerAppender();
    }

}
