package cn.com.duiba.cloud.log.client.integration.interceptor;

import cn.com.duiba.cloud.log.client.integration.BusinessLoggerInterceptor;
import cn.com.duiba.cloud.log.client.service.context.BusinessLoggerStackFrame;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/**
 * 功能描述：请求参数拦截
 *
 * @Auther: xiaotian
 * @Date: 2021/12/3 13:34
 * @Description:
 */
public class RequestBusinessLoggerInterceptor implements BusinessLoggerInterceptor {

    @Override
    public boolean doHandler(BusinessLoggerStackFrame frame) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        frame.setIp(RequestTool.getIpAddr(servletRequestAttributes.getRequest()));
        return true;
    }
}
