package cn.com.duiba.cloud.log.client.integration.interceptor;

import brave.Span;
import brave.Tracer;
import brave.propagation.TraceContext;
import cn.com.duiba.cloud.log.client.integration.BusinessLoggerInterceptor;
import cn.com.duiba.cloud.log.client.service.context.BusinessLoggerStackFrame;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @author liuyao
 */
public class SleuthBusinessLoggerInterceptor implements BusinessLoggerInterceptor {

    @Resource
    private Tracer tracer;

    @Override
    public boolean doHandler(BusinessLoggerStackFrame frame) {
        Span span = tracer.currentSpan();
        if(Objects.isNull(span)){
            return true;
        }
        TraceContext context = span.context();
        frame.setTraceId(context.traceIdString());
        frame.setSpanId(context.spanIdString());
        return true;
    }
}
