package cn.com.duiba.cloud.log.client.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.log.client.domain.BusinessLog;
import cn.com.duiba.cloud.log.client.domain.BusinessLogKeyParams;
import cn.com.duiba.cloud.log.client.domain.BusinessLogPageParams;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;


/**
 * @author liuyao
 */
@AdvancedFeignClient
public interface RemoteBusinessLoggerService {

    /**
     * 日志记录
     */
    void log(BusinessLog businessLog) throws BizException;

    /**
     * 分页检索
     */
    PageResponse<BusinessLog> findBusinessLogPage(BusinessLogPageParams params) throws BizException;

    /**
     * 根据检索条件查出对应字段的可选项
     */
    List<String> findBusinessLogKey(BusinessLogKeyParams params);
}
