package cn.com.duiba.cloud.log.client.service;

import cn.com.duiba.cloud.log.client.domain.BusinessLog;
import cn.com.duiba.cloud.log.client.integration.BusinessLoggerAppender;
import cn.com.duiba.cloud.log.client.service.context.BusinessLoggerStackFrame;
import cn.com.duiba.cloud.log.client.util.TemplateUtil;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.util.Date;
import java.util.List;
import java.util.Optional;

/**
 * 日志发布器
 *
 * @author liuyao
 */
@Slf4j
@Data
public class BusinessLoggerDispatcher implements Runnable {

    private BusinessLoggerStackFrame stackFrame;

    private String appName;

    private String environment;

    private List<BusinessLoggerAppender> businessLoggerAppenderList;

    /**
     * 异步线程执行消息发送逻辑
     **/
    @Override
    public void run() {
        try {

            JSONObject params = stackFrame.getParams();
            String logContext = TemplateUtil.replaceArgs(stackFrame.getTemplate(), params);
            BusinessLog param = new BusinessLog();
            param.setActionTime(new Date());
            param.setAppName(appName);
            param.setGroup(Optional.ofNullable(stackFrame.getGroup()).orElse("unknown"));
            param.setIp(stackFrame.getIp());
            param.setAppInfoId(stackFrame.getAppInfoId());
            param.setTraceId(stackFrame.getTraceId());
            param.setSpanId(stackFrame.getSpanId());
            param.setOperator(Optional.ofNullable(stackFrame.getOperator()).orElse("unknown"));
            param.setParamsJson(params.toJSONString());
            param.setLogContent(logContext);
            param.setErrorLog(stackFrame.isErrorLog());
            param.setSearchList(stackFrame.getSearchList());

            for (BusinessLoggerAppender appender : businessLoggerAppenderList) {
                try {
                    BusinessLog clone = new BusinessLog();
                    BeanUtils.copy(param, clone);
                    appender.acceptLog(clone);
                } catch (Exception e) {
                    log.error("Class[{}]处理操作日志失败", appender.getClass().getSimpleName(), e);
                }
            }
        } catch (Exception e) {
            log.error("操作日志发送失败", e);
        }
    }
}