package cn.com.duiba.cloud.log.client.service;

import cn.com.duiba.cloud.log.client.BusinessLogger;
import cn.com.duiba.cloud.log.client.integration.BusinessLoggerAppender;
import cn.com.duiba.cloud.log.client.service.context.BusinessLoggerStackFrame;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;

/**
 * 业务日志服务
 * @author liuyao
 */
public class BusinessLoggerService{
    /**
     * 由切面产生,如果没有此日志线程对象,则MyLogger的无法打印日志
     */
    private final ThreadLocal<BusinessLoggerStackContext> threadContext = new ThreadLocal<>();

    @Resource(name = "logExecutorService")
    private ExecutorService logExecutorService;
    @Autowired(required = false)
    private List<BusinessLoggerAppender> businessLoggerAppenderList;
    @Value("${spring.application.name}")
    private String appName;

    @PostConstruct
    public void init(){
        BusinessLogger.setBusinessLoggerService(this);
    }

    /**
     * 初始化 stackContext
     */
    protected void initStackContext(BusinessLoggerStackFrame frame) {
        BusinessLoggerStackContext context = threadContext.get();
        if (Objects.isNull(context)) {

            context = new BusinessLoggerStackContext();
            threadContext.set(context);
        }
        context.addStackFrame(frame);
    }

    public BusinessLoggerStackContext getBusinessLoggerStackContext(){
        return threadContext.get();
    }

    /**
     * 打印业务日志
     * 封装 task 异步线程池执行
     */
    protected void flushThreadContext(boolean persistence) {
        BusinessLoggerStackContext stackContext = threadContext.get();
        if (Objects.isNull(stackContext)) {
            return;
        }
        BusinessLoggerStackFrame frame = stackContext.popStackFrame();
        if (stackContext.isEmpty()) {
            threadContext.remove();
        }
        if(!persistence || Objects.isNull(frame) || businessLoggerAppenderList==null){
            return;
        }
        BusinessLoggerDispatcher dispatcher = new BusinessLoggerDispatcher();
        dispatcher.setStackFrame(frame);
        dispatcher.setAppName(appName);
        dispatcher.setBusinessLoggerAppenderList(businessLoggerAppenderList);
        logExecutorService.submit(dispatcher);
    }

}