package cn.com.duiba.cloud.log.client.service;

import cn.com.duiba.cloud.log.client.service.context.BusinessLoggerStackFrame;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;

import java.util.Objects;
import java.util.Stack;

/**
 * 业务日志栈
 * @author liuyao
 */
@Slf4j
public class BusinessLoggerStackContext {

    private final Stack<BusinessLoggerStackFrame> loggerStack = new Stack<>();

    public BusinessLoggerStackContext addLogParam(JSONObject param) {
        BusinessLoggerStackFrame context = getCurrentStackFrame();
        context.addParam(param);
        return this;
    }

    public BusinessLoggerStackContext addLogParam(String key, Object value) {
        BusinessLoggerStackFrame context = getCurrentStackFrame();
        context.addParam(key, value);
        return this;
    }

    private BusinessLoggerStackFrame getCurrentStackFrame(){
        BusinessLoggerStackFrame frame = loggerStack.peek();
        if(Objects.isNull(frame)){
            throw new UnsupportedOperationException("当前方法未处于业务切面,无法获取日志栈");
        }
        return frame;
    }

    protected BusinessLoggerStackFrame popStackFrame() {
        if (loggerStack.isEmpty()) {
            return null;
        }
        return loggerStack.pop();
    }

    protected void addStackFrame(BusinessLoggerStackFrame frame) {
        loggerStack.push(frame);
    }

    protected boolean isEmpty(){
        return loggerStack.isEmpty();
    }
}