package cn.com.duiba.cloud.log.client.service.context;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * 业务日志栈帧
 * @author liuyao
 */
@Slf4j
@Data
public class BusinessLoggerStackFrame {

    /**
     * 模版参数
     */
    private final JSONObject params = new JSONObject();
    /**
     * 日志模版
     */
    private String template;
    /**
     * 模块名称
     */
    private String group;
    /**
     * 提交日志的链路id
     */
    private String traceId;
    /**
     * spanId
     */
    private String spanId;

    /**
     * 系统级别租户纬度字段
     */
    private String appInfoId;

    /**
     * 操作人名字
     */
    private String operator;

    /**
     * 操作人id
     */
    private String operatorId;
    /**
     * 产生日志ip
     */
    private String ip;
    /**
     * 是否异常日志
     */
    private boolean errorLog = false;

    /**
     * 自定义搜索字段
     */
    private List<String> searchList;

    public void addParam(JSONObject param) {
        this.params.putAll(param);
    }

    public void addParam(String key, Object value) {
        this.params.put(key, value);
    }

}