/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.log.client.integration.appender.rocketmq;

import cn.com.duiba.cloud.log.client.domain.BusinessLog;
import cn.com.duiba.cloud.log.client.integration.BusinessLoggerAppender;
import cn.com.duiba.cloud.log.client.integration.appender.rocketmq.RocketMqProperties;
import com.alibaba.fastjson.JSON;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMqBusinessLoggerAppender
implements BusinessLoggerAppender {
    private static final Logger log = LoggerFactory.getLogger(RocketMqBusinessLoggerAppender.class);
    @Resource
    private RocketMQTemplate rocketMqTemplate;
    @Resource
    private RocketMqProperties rocketMqProperties;

    @Override
    public void acceptLog(BusinessLog param) {
        try {
            SendResult result = this.rocketMqTemplate.syncSend(this.rocketMqProperties.getTopic(), (Object)param, (long)this.rocketMqProperties.getSendMsgTimeoutMillis().intValue());
            if (Objects.isNull(result) || !SendStatus.SEND_OK.equals((Object)result.getSendStatus())) {
                log.error("send mq error, send={}, body={}", (Object)JSON.toJSONString((Object)result), (Object)param);
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff1a", (Throwable)e);
        }
    }
}

