/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.log.client.service;

import cn.com.duiba.cloud.log.client.domain.BusinessLog;
import cn.com.duiba.cloud.log.client.integration.BusinessLoggerAppender;
import cn.com.duiba.cloud.log.client.service.context.BusinessLoggerStackFrame;
import cn.com.duiba.cloud.log.client.util.TemplateUtil;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessLoggerDispatcher
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(BusinessLoggerDispatcher.class);
    private BusinessLoggerStackFrame stackFrame;
    private String appName;
    private String environment;
    private List<BusinessLoggerAppender> businessLoggerAppenderList;

    @Override
    public void run() {
        try {
            JSONObject params = this.stackFrame.getParams();
            String logContext = TemplateUtil.replaceArgs(this.stackFrame.getTemplate(), params);
            BusinessLog param = new BusinessLog();
            param.setActionTime(new Date());
            param.setAppName(this.appName);
            param.setGroup(Optional.ofNullable(this.stackFrame.getGroup()).orElse("unknown"));
            param.setIp(this.stackFrame.getIp());
            param.setAppInfoId(this.stackFrame.getAppInfoId());
            param.setTraceId(this.stackFrame.getTraceId());
            param.setSpanId(this.stackFrame.getSpanId());
            param.setOperator(Optional.ofNullable(this.stackFrame.getOperator()).orElse("unknown"));
            param.setParamsJson(params.toJSONString());
            param.setLogContent(logContext);
            param.setErrorLog(this.stackFrame.isErrorLog());
            param.setSearchList(this.stackFrame.getSearchList());
            for (BusinessLoggerAppender appender : this.businessLoggerAppenderList) {
                try {
                    BusinessLog clone = new BusinessLog();
                    BeanUtils.copy((Object)param, (Object)clone);
                    appender.acceptLog(clone);
                }
                catch (Exception e) {
                    log.error("Class[{}]\u5904\u7406\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25", (Object)appender.getClass().getSimpleName(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u65e5\u5fd7\u53d1\u9001\u5931\u8d25", (Throwable)e);
        }
    }

    public BusinessLoggerStackFrame getStackFrame() {
        return this.stackFrame;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public List<BusinessLoggerAppender> getBusinessLoggerAppenderList() {
        return this.businessLoggerAppenderList;
    }

    public void setStackFrame(BusinessLoggerStackFrame stackFrame) {
        this.stackFrame = stackFrame;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setBusinessLoggerAppenderList(List<BusinessLoggerAppender> businessLoggerAppenderList) {
        this.businessLoggerAppenderList = businessLoggerAppenderList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessLoggerDispatcher)) {
            return false;
        }
        BusinessLoggerDispatcher other = (BusinessLoggerDispatcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BusinessLoggerStackFrame this$stackFrame = this.getStackFrame();
        BusinessLoggerStackFrame other$stackFrame = other.getStackFrame();
        if (this$stackFrame == null ? other$stackFrame != null : !((Object)this$stackFrame).equals(other$stackFrame)) {
            return false;
        }
        String this$appName = this.getAppName();
        String other$appName = other.getAppName();
        if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
            return false;
        }
        String this$environment = this.getEnvironment();
        String other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        List<BusinessLoggerAppender> this$businessLoggerAppenderList = this.getBusinessLoggerAppenderList();
        List<BusinessLoggerAppender> other$businessLoggerAppenderList = other.getBusinessLoggerAppenderList();
        return !(this$businessLoggerAppenderList == null ? other$businessLoggerAppenderList != null : !((Object)this$businessLoggerAppenderList).equals(other$businessLoggerAppenderList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BusinessLoggerDispatcher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BusinessLoggerStackFrame $stackFrame = this.getStackFrame();
        result = result * 59 + ($stackFrame == null ? 43 : ((Object)$stackFrame).hashCode());
        String $appName = this.getAppName();
        result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
        String $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        List<BusinessLoggerAppender> $businessLoggerAppenderList = this.getBusinessLoggerAppenderList();
        result = result * 59 + ($businessLoggerAppenderList == null ? 43 : ((Object)$businessLoggerAppenderList).hashCode());
        return result;
    }

    public String toString() {
        return "BusinessLoggerDispatcher(stackFrame=" + this.getStackFrame() + ", appName=" + this.getAppName() + ", environment=" + this.getEnvironment() + ", businessLoggerAppenderList=" + this.getBusinessLoggerAppenderList() + ")";
    }
}

