/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.log.client.service;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.log.client.BusinessLoggerMethod;
import cn.com.duiba.cloud.log.client.integration.BusinessLoggerInterceptor;
import cn.com.duiba.cloud.log.client.service.BusinessLoggerService;
import cn.com.duiba.cloud.log.client.service.context.BusinessLoggerStackFrame;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.multipart.MultipartFile;

@Aspect
public class BusinessLoggerProxy {
    private static final Logger log = LoggerFactory.getLogger(BusinessLoggerProxy.class);
    public static final String RESPONSE = "response";
    private final LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();
    @Resource
    private BusinessLoggerService businessLoggerService;
    @Autowired(required=false)
    private List<BusinessLoggerInterceptor> businessLoggerInterceptors;

    @Around(value="@annotation(cn.com.duiba.cloud.log.client.BusinessLoggerMethod)")
    public Object logger(ProceedingJoinPoint point) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        BusinessLoggerMethod loggerMethod = (BusinessLoggerMethod)AnnotationUtils.findAnnotation((Method)method, BusinessLoggerMethod.class);
        String template = Objects.requireNonNull(loggerMethod).template();
        String group = loggerMethod.group();
        if (StringUtils.isBlank((String)template)) {
            throw new IllegalArgumentException("\u64cd\u4f5c\u65e5\u5fd7: " + group + ", template\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusinessLoggerStackFrame frame = new BusinessLoggerStackFrame();
        frame.setTemplate(template);
        frame.setGroup(group);
        this.businessLoggerService.initStackContext(frame);
        if (loggerMethod.request()) {
            Object[] arguments = point.getArgs();
            String[] paramNames = this.discoverer.getParameterNames(method);
            for (int i = 0; i < Objects.requireNonNull(paramNames).length; ++i) {
                String paramName = paramNames[i];
                Object value = arguments[i];
                if (value instanceof ServletRequest || value instanceof ServletResponse || value instanceof MultipartFile) continue;
                frame.addParam(paramName, value);
            }
        }
        boolean persistence = this.doInterceptor(frame);
        try {
            Object result = point.proceed();
            if (loggerMethod.response() && !(result instanceof ServletRequest) && !(result instanceof ServletResponse) && !(result instanceof MultipartFile)) {
                frame.addParam(RESPONSE, result);
            }
            Object i = result;
            return i;
        }
        catch (Exception e) {
            Throwable exception = e;
            while (exception instanceof InvocationTargetException) {
                exception = ((InvocationTargetException)exception).getTargetException();
            }
            frame.setErrorLog(!(exception instanceof BizException));
            if (Objects.nonNull(e) && StringUtils.isNotBlank((String)e.getMessage())) {
                String msg = e.getMessage().length() > 1000 ? e.getMessage().substring(0, 1000) : e.getMessage();
                frame.addParam(RESPONSE, msg);
            }
            throw e;
        }
        finally {
            this.businessLoggerService.flushThreadContext(persistence);
        }
    }

    private boolean doInterceptor(BusinessLoggerStackFrame frame) {
        for (BusinessLoggerInterceptor interceptor : this.businessLoggerInterceptors) {
            boolean persistence = interceptor.doHandler(frame);
            if (persistence) continue;
            return false;
        }
        return true;
    }
}

