/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.log.client.service;

import cn.com.duiba.cloud.log.client.BusinessLogger;
import cn.com.duiba.cloud.log.client.integration.BusinessLoggerAppender;
import cn.com.duiba.cloud.log.client.service.BusinessLoggerDispatcher;
import cn.com.duiba.cloud.log.client.service.BusinessLoggerStackContext;
import cn.com.duiba.cloud.log.client.service.context.BusinessLoggerStackFrame;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class BusinessLoggerService {
    private final ThreadLocal<BusinessLoggerStackContext> threadContext = new ThreadLocal();
    @Resource(name="logExecutorService")
    private ExecutorService logExecutorService;
    @Autowired(required=false)
    private List<BusinessLoggerAppender> businessLoggerAppenderList;
    @Value(value="${spring.application.name}")
    private String appName;

    @PostConstruct
    public void init() {
        BusinessLogger.setBusinessLoggerService(this);
    }

    protected void initStackContext(BusinessLoggerStackFrame frame) {
        BusinessLoggerStackContext context = this.threadContext.get();
        if (Objects.isNull(context)) {
            context = new BusinessLoggerStackContext();
            this.threadContext.set(context);
        }
        context.addStackFrame(frame);
    }

    public BusinessLoggerStackContext getBusinessLoggerStackContext() {
        BusinessLoggerStackContext context = this.threadContext.get();
        if (Objects.isNull(context)) {
            throw new UnsupportedOperationException("\u5f53\u524d\u7ebf\u7a0b\u6ca1\u6709\u4f4d\u4e8eSso\u64cd\u4f5c\u7684\u65e5\u5fd7\u5207\u9762\u4e2d");
        }
        return context;
    }

    protected void flushThreadContext(boolean persistence) {
        BusinessLoggerStackContext stackContext = this.threadContext.get();
        if (Objects.isNull(stackContext)) {
            return;
        }
        BusinessLoggerStackFrame frame = stackContext.popStackFrame();
        if (stackContext.isEmpty()) {
            this.threadContext.remove();
        }
        if (!persistence || Objects.isNull(frame) || this.businessLoggerAppenderList == null) {
            return;
        }
        BusinessLoggerDispatcher dispatcher = new BusinessLoggerDispatcher();
        dispatcher.setStackFrame(frame);
        dispatcher.setAppName(this.appName);
        dispatcher.setBusinessLoggerAppenderList(this.businessLoggerAppenderList);
        this.logExecutorService.submit(dispatcher);
    }
}

