/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.log.client.service;

import cn.com.duiba.cloud.log.client.service.context.BusinessLoggerStackFrame;
import com.alibaba.fastjson.JSONObject;
import java.util.Objects;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessLoggerStackContext {
    private static final Logger log = LoggerFactory.getLogger(BusinessLoggerStackContext.class);
    private final Stack<BusinessLoggerStackFrame> loggerStack = new Stack();

    public BusinessLoggerStackContext addLogParam(JSONObject param) {
        BusinessLoggerStackFrame context = this.getCurrentStackFrame();
        context.addParam(param);
        return this;
    }

    public BusinessLoggerStackContext addLogParam(String key, Object value) {
        BusinessLoggerStackFrame context = this.getCurrentStackFrame();
        context.addParam(key, value);
        return this;
    }

    private BusinessLoggerStackFrame getCurrentStackFrame() {
        BusinessLoggerStackFrame frame = this.loggerStack.peek();
        if (Objects.isNull(frame)) {
            throw new UnsupportedOperationException("\u5f53\u524d\u65b9\u6cd5\u672a\u5904\u4e8e\u4e1a\u52a1\u5207\u9762,\u65e0\u6cd5\u83b7\u53d6\u65e5\u5fd7\u6808");
        }
        return frame;
    }

    protected BusinessLoggerStackFrame popStackFrame() {
        if (this.loggerStack.isEmpty()) {
            return null;
        }
        return this.loggerStack.pop();
    }

    protected void addStackFrame(BusinessLoggerStackFrame frame) {
        this.loggerStack.push(frame);
    }

    protected boolean isEmpty() {
        return this.loggerStack.isEmpty();
    }
}

