/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.openapi.service.api.config;

import cn.com.duiba.cloud.duiba.openapi.service.api.annotation.OpenApi;
import cn.com.duiba.cloud.duiba.openapi.service.api.annotation.OpenPath;
import cn.com.duiba.cloud.duiba.openapi.service.api.config.OpenApiProperty;
import cn.com.duiba.cloud.duiba.openapi.service.api.param.ApiRegisterParam;
import cn.com.duiba.cloud.duiba.openapi.service.api.remoteservice.RemoteApiRegisterService;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

@EnableConfigurationProperties(value={OpenApiProperty.class})
@Configuration
public class OpenApiConfig
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(OpenApiConfig.class);
    @Autowired
    private OpenApiProperty openApiProperty;
    @Autowired
    private RemoteApiRegisterService remoteApiRegisterService;
    @Value(value="${spring.application.name}")
    private String serviceName;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (!this.openApiProperty.isEnable()) {
            return;
        }
        Map beansWithAnnotation = applicationContext.getBeansWithAnnotation(OpenApi.class);
        for (Map.Entry entry : beansWithAnnotation.entrySet()) {
            Method[] methods;
            Object obj = entry.getValue();
            OpenApi openApi = (OpenApi)AnnotationUtils.findAnnotation(obj.getClass(), OpenApi.class);
            assert (openApi != null);
            String prefix = openApi.prefix();
            for (Method method : methods = ReflectionUtils.getAllDeclaredMethods(obj.getClass())) {
                OpenPath openPath = (OpenPath)AnnotationUtils.findAnnotation((Method)method, OpenPath.class);
                if (null == openPath) continue;
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (parameterTypes.length > 1) {
                    throw new IllegalArgumentException(MessageFormat.format("{0}#{1}\u53c2\u6570\u5fc5\u987b\u5c01\u88c5\u6210\u7b80\u5355\u5bf9\u8c61\uff0c\u5426\u5219\u65e0\u6cd5\u89e3\u6790", obj.getClass().getSimpleName(), method.getName()));
                }
                String apiPath = Optional.ofNullable(openPath.apiPath()).orElseThrow(() -> new IllegalArgumentException("\u8bf7\u8bbe\u7f6eApiPath\u8def\u5f84 \u4f8b\u5982\uff1a/test"));
                apiPath = prefix + apiPath;
                log.info("\u6210\u529f\u8bfb\u53d6OpenApi\u8def\u5f84\uff1a{}", (Object)apiPath);
                ApiRegisterParam registerParam = new ApiRegisterParam();
                registerParam.setApiPath(apiPath);
                registerParam.setApiDesc(openPath.apiDesc());
                registerParam.setServiceName(this.serviceName);
                registerParam.setClassName(obj.getClass().getSimpleName());
                registerParam.setMethod(method.getName());
                if (1 == parameterTypes.length) {
                    registerParam.setMethodParamClass(parameterTypes[0].getTypeName());
                }
                log.info("OpenApi\u6ce8\u518c\u6210\u529f\uff1a{}", (Object)JSON.toJSONString((Object)registerParam));
            }
        }
    }
}

