# 开放平台提供对外接口

## 1、接入方式

### 引入包

在api层引入

```
provided "cn.com.duiba.cloud:duiba-openapi-service-api:0.0.1-SNAPSHOT"
```

添加配置

```
openapi.enable=true
```

注意包扫描
由于默认情况下，api模块下的代码不会被Spring注册，需要添加一下配置。
目的为了识别，开放平台提供的注解，进行接口注册

```
@SpringBootApplication(scanBasePackages = {"cn.com.duiba.cloud"})
```


添加接口声明注解

@OpenApi ：该注解放在接口｜类上，用来识别该类对外提供开放接口
@OpenPath：该注解放在方法上，用来配置接口
如下实例：

```
@OpenApi(prefix = "/payment")
@AdvancedFeignClient("duiba-payment-service")
public interface RemoteAccountService {
    @OpenPath(apiPath = "/queryAccountState",apiDesc = "查询用户账户状态信息")
    AccountStateDTO queryAccountState(AccountStateQueryParam param);

    @OpenPath(apiPath = "/queryAccountBill",apiDesc = "查询账户账单接口")
    PageResponse<PayBillDTO> queryAccountBill(PayBillPageQueryParam param);
}

```


启动结果：

```

```
