package cn.com.duiba.cloud.duiba.openapi.service.api.param;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;

import java.io.Serializable;

/**
 * 接口注册参数
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/20 5:03 下午
 **/
@Data
@NoArgsConstructor
public class ApiRegisterParam implements Serializable {
    private static final long serialVersionUID = -2622945843916408563L;
    /**
     * api路径
     */
    @NonNull
    private String apiPath;

    /**
     * 接口描述
     */
    @NonNull
    private String apiDesc;


    /**
     * 服务名
     */
    @NonNull
    private String serviceName;


    /**
     * 类名
     */
    @NonNull
    private String className;

    /**
     * 方法名
     */
    @NonNull
    private String method;

    /**
     * 路由类
     */
    @NonNull
    private String routeClass;

    /**
     * 方法参数类型
     */
    @NonNull
    private String methodParamClass;
}
