package cn.com.duiba.cloud.duiba.openapi.service.api.param;


import cn.com.duiba.cloud.duiba.openapi.service.api.enums.OpenEventSpreadEnum;
import cn.com.duiba.cloud.duiba.openapi.service.api.enums.OpenEventStrategyEnum;
import cn.com.duiba.cloud.duiba.openapi.service.api.enums.OpenEventTypeEnum;
import com.alibaba.fastjson.JSON;
import lombok.Data;

import java.io.Serializable;

/**
 * 事件推送消息
 * 发送消息时，需要转成JSONStr发送
 * 请使用以下静态方法创建对象：
 * 广播：PushEventMessageParam#createBroadcastEvent
 * 定向：PushEventMessageParam#createDirectionalEvent
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/1/13 7:37 下午
 **/
@Data
public class PushEventMessageParam implements Serializable {
    private static final long serialVersionUID = 509812608237632366L;
    /**
     * @see OpenEventTypeEnum
     */
    private Integer eventType;

    /**
     * 事件唯一标识
     */
    private String eventUid;


    /**
     * 传播类型
     *
     * @see cn.com.duiba.cloud.duiba.openapi.service.api.enums.OpenEventSpreadEnum
     */
    private Integer spreadType;

    /**
     * 策略类型
     * 传播类型为广播时，只支持弱策略
     *
     * @see cn.com.duiba.cloud.duiba.openapi.service.api.enums.OpenEventStrategyEnum
     */
    private Integer strategyType;

    /**
     * 应用id
     * 传播类型为，定向消息时 需要传
     */
    private Long appId;

    private Object content;

    /**
     * 创建广播事件
     *
     * @param eventType
     * @param eventUid
     * @param content
     * @return
     */
    public static String createBroadcastEvent(OpenEventTypeEnum eventType, String eventUid, Object content) {
        PushEventMessageParam param = new PushEventMessageParam();
        param.setEventType(eventType.getValue());
        param.setEventUid(eventUid);
        param.setSpreadType(OpenEventSpreadEnum.BROADCAST.getValue());
        param.setStrategyType(OpenEventStrategyEnum.weak.getValue());
        param.setContent(content);
        return JSON.toJSONString(param);
    }

    /**
     * 创建定向事件
     *
     * @param eventType
     * @param eventUid
     * @param content
     * @param eventStrategy
     * @param appId
     * @return
     */
    public static String createDirectionalEvent(OpenEventTypeEnum eventType, String eventUid, Object content, OpenEventStrategyEnum eventStrategy, Long appId) {
        PushEventMessageParam param = new PushEventMessageParam();
        param.setEventType(eventType.getValue());
        param.setEventUid(eventUid);
        param.setSpreadType(OpenEventSpreadEnum.DIRECTIONAL.getValue());
        param.setStrategyType(eventStrategy.getValue());
        param.setAppId(appId);
        param.setContent(content);
        return JSON.toJSONString(param);
    }

}
