package cn.com.duiba.cloud.duiba.openapi.service.api.remoteservice;


import cn.com.duiba.cloud.duiba.openapi.service.api.constants.OpenApiConstant;
import cn.com.duiba.cloud.duiba.openapi.service.api.dto.OpenApiConfigDTO;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

/**
 * 开放api路由
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/1/20 2:00 下午
 **/
public class OpenApiRoute {

    public Object apiRoute(JSONObject param) throws Exception {
        OpenApiConfigDTO apiConfig = param.getObject(OpenApiConstant.RouteParam.API_CONFIG, OpenApiConfigDTO.class);
        Object bean = SpringUtil.getBeanFactory().getBean(Class.forName(apiConfig.getClassName()));
        if (StringUtils.isBlank(apiConfig.getMethodParamClass())) {
            return bean.getClass().getMethod(apiConfig.getMethod()).invoke(bean);
        }

        Class<?> paramClass = Class.forName(apiConfig.getMethodParamClass());
        JSONObject requestParam = param.getJSONObject(OpenApiConstant.RouteParam.PARAM);
        return bean.getClass().getMethod(apiConfig.getMethod(), paramClass).invoke(bean, requestParam.toJavaObject(paramClass));
    }
}
