/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.openapi.service.api.utils;

import cn.com.duiba.cloud.duiba.openapi.service.api.annotation.OpenApi;
import cn.com.duiba.cloud.duiba.openapi.service.api.annotation.OpenPath;
import cn.hutool.core.lang.Assert;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

public class OpenApiDocUtil {
    public static String createApiDoc(Method method) {
        StringBuilder apiDoc = new StringBuilder();
        try {
            OpenApi openApi = method.getDeclaringClass().getDeclaredAnnotation(OpenApi.class);
            OpenPath openPath = method.getDeclaredAnnotation(OpenPath.class);
            if (openApi != null && openPath != null) {
                apiDoc.append("# " + openPath.apiDesc() + "\n");
                apiDoc.append("\n");
                apiDoc.append("---\n");
                apiDoc.append("\n");
                apiDoc.append("## " + openApi.prefix() + openPath.apiPath() + "\n");
                apiDoc.append("\n");
                apiDoc.append("\u63a5\u53e3\u63cf\u8ff0\uff1a" + openPath.apiDesc() + "\n");
            }
            apiDoc.append("> \u514d\u8d39 \uff5c \u5fc5\u987b\u7528\u6237\u6388\u6743 \uff5c \u7248\u672c1.0\n");
            apiDoc.append("\n");
            apiDoc.append("### \u8bf7\u6c42\u65b9\u5f0f\n");
            apiDoc.append("\n");
            apiDoc.append("**POST**\n");
            apiDoc.append("\n");
            apiDoc.append("### \u516c\u5171\u53c2\u6570\n");
            apiDoc.append("\n");
            apiDoc.append("\u516c\u5171\u8bf7\u6c42\u53c2\u6570\n");
            apiDoc.append("\n");
            apiDoc.append("|  \u53c2\u6570   | \u7c7b\u578b  |  \u5fc5\u987b   | \u63cf\u8ff0   |\n");
            apiDoc.append("|  ----  | ----  |  ----  | ----  |\n");
            apiDoc.append("|  access_token | String | \u662f  | \u6388\u6743\u7801\uff0cOAuth\u6388\u6743\u5f97\u5230\u5f97token\uff0c\u5fc5\u586b\u53c2\u6570 <br>**\u793a\u4f8b\u503c\uff1ad60ae854-cea2-45b7-84c8-db35e17ffc9c**|\n");
            apiDoc.append("\n");
            apiDoc.append("### \u8bf7\u6c42\u4f53\u53c2\u6570\n");
            apiDoc.append("\n");
            Class<?> type = method.getParameters()[0].getType();
            Assert.isFalse((boolean)type.isPrimitive(), (String)"\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u57fa\u672c\u7c7b\u578b", (Object[])new Object[0]);
            Field[] paramFields = type.getDeclaredFields();
            OpenApiDocUtil.createParam(apiDoc, paramFields);
            apiDoc.append("\n");
            apiDoc.append("### \u54cd\u5e94\u53c2\u6570\n");
            apiDoc.append("\n");
            Assert.isFalse((boolean)method.getReturnType().isPrimitive(), (String)"\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u57fa\u672c\u7c7b\u578b", (Object[])new Object[0]);
            Field[] returnTypeFields = method.getReturnType().getDeclaredFields();
            OpenApiDocUtil.createParam(apiDoc, returnTypeFields);
            apiDoc.append("\n");
            apiDoc.append("### \u8bf7\u6c42\u793a\u4f8b\n");
            apiDoc.append("\n");
            apiDoc.append("```json\n");
            apiDoc.append("\n");
            apiDoc.append("{\n    \"sign\": \"445F5858242040FB3EB7CEA3975C2905\",\n    \"param\": {\n        //\u8bf7\u6c42\u4f53\u53c2\u6570\n    }\n}\n");
            apiDoc.append("```\n");
            apiDoc.append("\n");
            apiDoc.append("### \u54cd\u5e94\u793a\u4f8b\n");
            apiDoc.append("\n");
            apiDoc.append("```json\n");
            apiDoc.append("{\n    \"success\": true,\n    \"code\": 1,\n    \"msg\": \"\u6210\u529f\",\n    \"data\": { \n        // \u7ed3\u679c\u5185\u5bb9\n    }\n}\n");
            apiDoc.append("```\n");
            apiDoc.append("\n");
            apiDoc.append("### \u5f02\u5e38\u793a\u4f8b\n");
            apiDoc.append("\n");
            apiDoc.append("```json\n");
            apiDoc.append("{\n");
            apiDoc.append("  \"success\": false,\n");
            apiDoc.append("  \"code\": -1,\n");
            apiDoc.append("  \"msg\": \"error\",\n");
            apiDoc.append("  \"data\": null\n");
            apiDoc.append("}\n");
            apiDoc.append("```\n");
            apiDoc.append("\n");
            apiDoc.append("---\n");
            System.out.println(apiDoc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return apiDoc.toString();
    }

    private static void createParam(StringBuilder apiDoc, Field[] returnTypeFields) throws ClassNotFoundException {
        HashSet expendTypes = new HashSet();
        apiDoc.append("\n");
        apiDoc.append("|  \u53c2\u6570   | \u7c7b\u578b  |  \u5fc5\u987b   | \u63cf\u8ff0   |\n");
        apiDoc.append("|  ----  | ----  |  ----  | ----  |\n");
        for (Field field : returnTypeFields) {
            if ("apiContext".equals(field.getName()) || Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            NotBlank notBlank = field.getAnnotation(NotBlank.class);
            NotNull notNull = field.getAnnotation(NotNull.class);
            String isNeed = notBlank != null && notNull != null ? "\u662f" : "\u5426";
            Type expendType = field.getType();
            String fieldTypeName = field.getType().getSimpleName();
            if (field.getGenericType() instanceof ParameterizedType) {
                ParameterizedType genericType = (ParameterizedType)field.getGenericType();
                String typeName = genericType.getActualTypeArguments()[0].getTypeName();
                String actualTypeArgument = typeName.substring(typeName.lastIndexOf(".") + 1);
                fieldTypeName = fieldTypeName + "\\<" + actualTypeArgument + "\\>";
                expendType = genericType.getActualTypeArguments()[0];
            }
            String str = "|  " + field.getName() + " | " + fieldTypeName + " | " + isNeed + "  |  <br>**\u793a\u4f8b\u503c\uff1a**|\n";
            apiDoc.append(str);
            Class<?> expendClass = Class.forName(expendType.getTypeName());
            if (OpenApiDocUtil.isBasic(expendClass.getName()).booleanValue() || expendClass.getClass().isPrimitive()) continue;
            expendTypes.add(expendClass);
        }
        for (Class clazz : expendTypes) {
            apiDoc.append("\n");
            apiDoc.append("**" + clazz.getSimpleName() + "**\n");
            OpenApiDocUtil.createParam(apiDoc, clazz.getDeclaredFields());
        }
    }

    private static Boolean isBasic(String name) {
        return name.contains("java.lang") || name.contains("java.util");
    }
}

