package cn.com.duiba.cloud.duiba.openapi.service.api.enums;

import lombok.Getter;

/**
 * @author huangguosheng@duiba.com.cn
 * @date 2022/7/25 11:25 上午
 **/
@Getter
public enum DocumentShowTypeEnum {
    /**
     * 展示类型
     */
    FOLDER(0, "文件夹"),
    FILE(1, "文件"),
    ;

    private Integer value;

    private String desc;

    DocumentShowTypeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (DocumentShowTypeEnum item : DocumentShowTypeEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static DocumentShowTypeEnum valueOf(Integer value) {
        for (DocumentShowTypeEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
