package cn.com.duiba.cloud.duiba.openapi.service.api.enums;

import lombok.Getter;

/**
 * @author huangguosheng@duiba.com.cn
 * @date 2022/7/25 11:25 上午
 **/
@Getter
public enum DocumentTypeEnum {
    /**
     * 文档类型类型
     */
    DEVELOP_DOC(1, "开发对接"),
    OPERATION_DOC(2, "操作手册"),
    ;

    private Integer value;

    private String desc;

    DocumentTypeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (DocumentTypeEnum item : DocumentTypeEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static DocumentTypeEnum valueOf(Integer value) {
        for (DocumentTypeEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
