/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.openapi.service.api.enums;

import lombok.Getter;

/**
 * 开放事件Tag
 * 底层服务通过mq到开放平台，开放平台会根据tag类型区分事件，进行事件推送,使用时取 name,OpenEventTagEnum.GOODS_CHANGE.name
 * 前缀格式，编号6位组成，前三位为业务分类
 * 用户：前缀：USER_*     编号前缀：100***
 * 商品：前缀：GOODS_*    编号前缀：200***
 * 订单：前缀：ORDER_*    编号前缀：300***
 * 支付：前缀：PAYMENT_*  编号前缀：400***
 * 资金：前缀：CAPITAL_*  编号前缀：500***
 * <p>
 * Topic: duiba-open-api-event
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/13 3:50 下午
 **/
@Getter
public enum OpenEventTypeEnum {
    /**
     * 事件Tag
     */
    GOODS_CHANGE(200001, "商品修改"),
    ORDER_DELIVERY(300001, "订单发货"),
    ;

    private Integer value;

    private String desc;

    OpenEventTypeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (OpenEventTypeEnum item : OpenEventTypeEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static OpenEventTypeEnum valueOf(Integer value) {
        for (OpenEventTypeEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
