package cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.MyPair;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.RechargeResponseDTO;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.fulu.FuLuBaseRespDTO;

/**
 * @Description 第三方下单充值回调类
 * @Author dangcang
 * @Date 2022/5/24 10:45 上午
 **/
@AdvancedFeignClient
public interface RemoteRechargeCallBackService {

    /**
     * 第三方订单状态回调
     *
     * @param responseDTO
     * @return
     * @throws BizException
     */
    Boolean rechargeCallBack(RechargeResponseDTO responseDTO) throws BizException;

    /**
     * 福禄定制充值回调
     *
     * @param fuLuBaseRespDTO 福禄基地resp dto
     * @throws BizException 业务异常
     */
    void fuLuRechargeCallback(FuLuBaseRespDTO fuLuBaseRespDTO) throws BizException;

    /**
     * 调用直充缓存 返回账户信息
     * key 账号 value 密钥
     * @param orderNum
     * @return
     */
    MyPair<String, String> accountPair(String orderNum);

}