package cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.BaseRechargeDTO;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.RechargeResponseDTO;

/**
 * 供应商充值远程服务
 *
 * @author zouwx
 * @date 2022/05/27
 */
@AdvancedFeignClient
public interface RemoteSupplerRechargeService {

    /**
     * 三方充值
     *
     * @param requestDTO 请求dto
     * @return 只表明openApi处理了请求 并不表示充值成功
     * @throws BizException 业务异常
     */
    Boolean tripartiteRecharge(BaseRechargeDTO requestDTO) throws BizException;

    /**
     * 查询充值订单
     *
     * @param queryDTO 查询dto
     * @return {@link RechargeResponseDTO}
     * @throws BizException 业务异常
     */
    RechargeResponseDTO queryOrder(BaseRechargeDTO queryDTO) throws BizException;
}
