/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.openapi.service.api.enums;

import lombok.Getter;

/**
 * 开放事件状态
 * <p>
 * Topic: duiba-open-api-event
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/14 3:50 下午
 **/
@Getter
public enum OpenEventStatusEnum {
    /**
     * 事件状态
     */
    OPEN(1, "开"),
    CLOSE(2, "关");;

    private Integer value;

    private String desc;

    OpenEventStatusEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (OpenEventStatusEnum item : OpenEventStatusEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static OpenEventStatusEnum valueOf(Integer value) {
        for (OpenEventStatusEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
