package cn.com.duiba.cloud.duiba.openapi.service.api.param;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * api文档
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/03/02 11:01 上午
 **/
@Data
public class DocumentUpdateParam implements Serializable {
    private static final long serialVersionUID = 4406896128715402448L;
    /**
     * id
     */
    @NotNull(message = "id不能为空")
    private Long id;

    /**
     * 标题
     */
    private String title;

    /**
     * 展示排序（编号越大越靠前）
     */
    private Integer showOrder;

    /**
     * 展示类型
     * 0-目录 1-文档
     */
    private Integer showType;

    /**
     * 父类id
     */
    private Long parentId;

    /**
     * 文档状态
     */
    private Integer documentStatus;

    /**
     * 文档内容
     */
    private String document;

    /**
     * 是否删除
     */
    private Boolean isDelete;
}