package cn.com.duiba.cloud.duiba.openapi.service.api.param;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;

/**
 * 限流列表查询
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/3/2 1:54 下午
 **/
@Data
@EqualsAndHashCode(callSuper=true)
public class FLowLimitUpdateParam extends PageRequest {
    private static final long serialVersionUID = 5737355171700718333L;

    @NotNull(message = "id不能为空")
    private Long id;

    /**
     * 阈值
     */
    private Integer threshold;

    /**
     * 限流模式（0-单机 1-集群）
     */
    private Integer limitType;

    /**
     * 阈值类型(0-QPS 1-并发线程数)
     */
    private Integer thresholdType;

    /**
     * 限流状态（1-失效、2-生效）
     */
    private Integer limitStatus;
}
