/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.openapi.service.api.enums;

import lombok.Getter;

/**
 * 通用状态
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/5 3:50 下午
 **/
@Getter
public enum OpenCommonStatusEnum {
    /**
     * 通用状态
     */
    ENABLE(1, "是"),
    DISABLE(2, "否"),;

    private Integer value;

    private String desc;

    OpenCommonStatusEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (OpenCommonStatusEnum item : OpenCommonStatusEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static OpenCommonStatusEnum valueOf(Integer value) {
        for (OpenCommonStatusEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
