package cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Description 充值上下文
 * @Author dangcang
 * @Date 2022/5/24 1:54 下午
 **/
@Data
public class RechargeContextDTO implements Serializable {

    private static final long serialVersionUID = -3384934357544419544L;

    /**
     * 主订单号
     */
    @NotBlank(message = "业务订单号不能为空")
    private String mainOrderNum;

    /**
     * 业务主体类型
     */
    @NotNull(message = "业务主体类型不能为空")
    private Long businessType;

    /**
     * 应用程序id
     */
    @NotNull(message = "appId不能为空")
    private Long appId;

    /**
     * mq回调topic
     * 回调消息都是
     * @see cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.RechargeResponseDTO
     */
    private String callbackTopic;

    /**
     * mq回调tag
     */
    private String callbackTag;

    /**
     * mq回调key
     */
    private String callbackKey;
}