package cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.pushang;

import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.RechargeContextDTO;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 浦上话费充值
 *
 * @author zouwx
 * @date 2022/05/25
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class PuShangPhoneReqDTO extends RechargeContextDTO implements Serializable {

    private static final long serialVersionUID = -4742707095669763970L;

    /**
     * 第三方订单号
     */
    @NotBlank(message = "订单号不能为空")
    private String extOrderId;

    /**
     * 充值手机号
     */
    @NotBlank(message = "充值手机号不能为空")
    private String phone;

    /**
     * 充值金额
     */
    @NotNull(message = "充值金额不能为空")
    private Integer amt;

    /**
     * 业务主体类型
     */
    @NotNull(message = "业务主体类型不能为空")
    private Long businessType;

    /**
     * 是否含税
     */
    @NotNull(message = "是否含税不能为空")
    private Integer includeTax;
}
