package cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.pushang;

import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.RechargeContextDTO;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 浦上影音娱乐充值
 *
 * @author zouwx
 * @date 2022/05/25
 */
@Data
public class PuShangVideoReqDTO extends RechargeContextDTO implements Serializable {

    private static final long serialVersionUID = -3720132446392932898L;


    /**
     * 第三方订单号
     */
    @NotBlank(message = "订单号不能为空")
    private String extOrderId;

    /**
     * 产品id
     */
    @NotBlank(message = "商品编码不能为空")
    private String productId;

    /**
     * 充值账户
     */
    @NotBlank(message = "充值账号不能为空")
    private String account;

    /**
     * 购买数量数量
     */
    @NotNull(message = "购买数量不能为空")
    private Integer number;

    /**
     * 业务主体类型
     */
    @NotNull(message = "业务主体类型不能为空")
    private Long businessType;
}
