package cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.BaseRechargeQueryDTO;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.RechargeResponseDTO;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.fulu.OrderCardAddDTO;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.fulu.OrderDirectAddReqDTO;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.fulu.OrderInfoGetReqDTO;

/**
 * 远程福禄服务
 *
 * @author zouwx
 * @date 2022/05/25
 */
@AdvancedFeignClient
public interface RemoteFuLuService {

    /**
     *
     * 福禄直冲
     * @param requestDTO 请求dto
     * @return 只表明openApi处理了请求 并不表示充值成功
     * @throws BizException 业务异常
     */
    Boolean amusementRecharge(OrderDirectAddReqDTO requestDTO) throws BizException;

    /**
     * 卡券创建订单
     *
     * @param orderCardAddDTO 订单卡片添加dto
     * @return {@link Boolean}
     * @throws BizException 业务异常
     */
    Boolean cardRecharge(OrderCardAddDTO orderCardAddDTO) throws BizException;

    /**
     * 直冲订单状态查询
     *
     * @param queryDTO 查询dto
     * @return {@link RechargeResponseDTO}
     * @throws BizException 业务异常
     */
    RechargeResponseDTO queryAmusementOrder(OrderInfoGetReqDTO queryDTO) throws BizException;

    /**
     * 查询卡密订单
     *
     * @param queryDTO 查询dto
     * @return {@link RechargeResponseDTO}
     * @throws BizException 业务异常
     */
    RechargeResponseDTO queryCardOrder(OrderInfoGetReqDTO queryDTO) throws BizException;
}
