package cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.BaseRechargeQueryDTO;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.RechargeResponseDTO;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.XiangshangTelephoneRechargeRequestDTO;

/**
 * @Description 向上供应商 对接类
 * @Author dangcang
 * @Date 2022/5/24 10:45 上午
 **/
@AdvancedFeignClient
public interface RemoteXiangShangService {

    /**
     * 话费充值
     * @param requestDTO
     * @return 只表明openApi处理了请求 并不表示充值成功
     * @throws BizException
     */
    Boolean telephoneRecharge(XiangshangTelephoneRechargeRequestDTO requestDTO) throws BizException;

    /**
     * 订单状态查询
     * @param queryDTO
     * @return
     * @throws BizException
     */
    RechargeResponseDTO queryOrder(BaseRechargeQueryDTO queryDTO) throws BizException;


}